<?php

declare(strict_types=1);

/*
 * PaypalServerSdkLib
 *
 * This file was automatically generated by APIMATIC v3.0 ( https://www.apimatic.io ).
 */

namespace PaypalServerSdkLib\Models;

use PaypalServerSdkLib\ApiHelper;
use stdClass;

/**
 * The Balance information.
 */
class BalanceInformation implements \JsonSerializable
{
    /**
     * @var string
     */
    private $currency;

    /**
     * @var bool|null
     */
    private $primary;

    /**
     * @var Money
     */
    private $totalBalance;

    /**
     * @var Money|null
     */
    private $availableBalance;

    /**
     * @var Money|null
     */
    private $withheldBalance;

    /**
     * @param string $currency
     * @param Money $totalBalance
     */
    public function __construct(string $currency, Money $totalBalance)
    {
        $this->currency = $currency;
        $this->totalBalance = $totalBalance;
    }

    /**
     * Returns Currency.
     * The [three-character ISO-4217 currency code](/docs/integration/direct/rest/currency-codes/) that
     * identifies the currency.
     */
    public function getCurrency(): string
    {
        return $this->currency;
    }

    /**
     * Sets Currency.
     * The [three-character ISO-4217 currency code](/docs/integration/direct/rest/currency-codes/) that
     * identifies the currency.
     *
     * @required
     * @maps currency
     */
    public function setCurrency(string $currency): void
    {
        $this->currency = $currency;
    }

    /**
     * Returns Primary.
     * Optional field representing if the currency is primary currency or not.
     */
    public function getPrimary(): ?bool
    {
        return $this->primary;
    }

    /**
     * Sets Primary.
     * Optional field representing if the currency is primary currency or not.
     *
     * @maps primary
     */
    public function setPrimary(?bool $primary): void
    {
        $this->primary = $primary;
    }

    /**
     * Returns Total Balance.
     * The currency and amount for a financial transaction, such as a balance or payment due.
     */
    public function getTotalBalance(): Money
    {
        return $this->totalBalance;
    }

    /**
     * Sets Total Balance.
     * The currency and amount for a financial transaction, such as a balance or payment due.
     *
     * @required
     * @maps total_balance
     */
    public function setTotalBalance(Money $totalBalance): void
    {
        $this->totalBalance = $totalBalance;
    }

    /**
     * Returns Available Balance.
     * The currency and amount for a financial transaction, such as a balance or payment due.
     */
    public function getAvailableBalance(): ?Money
    {
        return $this->availableBalance;
    }

    /**
     * Sets Available Balance.
     * The currency and amount for a financial transaction, such as a balance or payment due.
     *
     * @maps available_balance
     */
    public function setAvailableBalance(?Money $availableBalance): void
    {
        $this->availableBalance = $availableBalance;
    }

    /**
     * Returns Withheld Balance.
     * The currency and amount for a financial transaction, such as a balance or payment due.
     */
    public function getWithheldBalance(): ?Money
    {
        return $this->withheldBalance;
    }

    /**
     * Sets Withheld Balance.
     * The currency and amount for a financial transaction, such as a balance or payment due.
     *
     * @maps withheld_balance
     */
    public function setWithheldBalance(?Money $withheldBalance): void
    {
        $this->withheldBalance = $withheldBalance;
    }

    /**
     * Converts the BalanceInformation object to a human-readable string representation.
     *
     * @return string The string representation of the BalanceInformation object.
     */
    public function __toString(): string
    {
        return ApiHelper::stringify(
            'BalanceInformation',
            [
                'currency' => $this->currency,
                'primary' => $this->primary,
                'totalBalance' => $this->totalBalance,
                'availableBalance' => $this->availableBalance,
                'withheldBalance' => $this->withheldBalance
            ]
        );
    }

    /**
     * Encode this object to JSON
     *
     * @param bool $asArrayWhenEmpty Whether to serialize this model as an array whenever no fields
     *        are set. (default: false)
     *
     * @return array|stdClass
     */
    #[\ReturnTypeWillChange] // @phan-suppress-current-line PhanUndeclaredClassAttribute for (php < 8.1)
    public function jsonSerialize(bool $asArrayWhenEmpty = false)
    {
        $json = [];
        $json['currency']              = $this->currency;
        if (isset($this->primary)) {
            $json['primary']           = $this->primary;
        }
        $json['total_balance']         = $this->totalBalance;
        if (isset($this->availableBalance)) {
            $json['available_balance'] = $this->availableBalance;
        }
        if (isset($this->withheldBalance)) {
            $json['withheld_balance']  = $this->withheldBalance;
        }

        return (!$asArrayWhenEmpty && empty($json)) ? new stdClass() : $json;
    }
}
